<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Company extends Model 
{

    protected $table = 'companies';
    public $timestamps = true;
    protected $fillable = array('name', 'admin_id', 'website', 'logo', 'description', 'location', 'size', 'hired_people');

    public function jobs()
    {
        return $this->hasMany('App\Models\Job');
    }

    public function admin()
    {
        return $this->belongsTo('App\Models\Admin');
    }

    public function profiles()
    {
        return $this->belongsToMany('App\Models\Profile');
    }

}